<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: reconvert_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_reconvert_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_modal_notice('update', "Converting Audio Files - please be patient");
    ini_set('max_execution_time', 82800); // 23 hours max

    $_allowed_exts = jrAudio_get_audio_types();

    // Get Audio files and create queue entries
    $iid = 0;
    $num = 0;
    while (true) {

        $_sp = array(
            'search'         => array(
                "_item_id > {$iid}"
            ),
            'order_by'       => array(
                '_item_id' => 'asc'
            ),
            'privacy_check'  => false,
            'quota_check'    => false,
            'ignore_pending' => true,
            'limit'          => 100
        );
        if (isset($_post['convert_quotas']) && jrCore_checktype($_post['convert_quotas'], 'number_nz')) {
            $_sp['search'][] = "profile_quota_id = {$_post['convert_quotas']}";
        }
        $_sg = jrCore_db_search_items('jrAudio', $_sp);
        if ($_sg && is_array($_sg) && isset($_sg['_items']) && is_array($_sg['_items'])) {

            foreach ($_sg['_items'] as $v) {

                if (!isset($_allowed_exts["{$v['audio_file_extension']}"])) {
                    // This is not a supported file type
                    continue;
                }

                $iid = (int) $v['_item_id'];
                // See if we have to convert this audio file
                // convert_all will be ON if we are FORCING reconversion of all audio files
                if (isset($_post['convert_all']) && $_post['convert_all'] == 'off') {
                    // We are not forcing reconversion - make sure we need to be converted
                    if (isset($v['audio_file_bitrate']) && $v['audio_file_bitrate'] <= $v['quota_jrAudio_conversion_bitrate']) {
                        // We are already at the right bitrate or LOWER - we do
                        // not convert a lower bitrate file to higher bitrate
                        continue;
                    }
                }

                // Fall through - we either need converting OR we are forcing conversion
                $_queue = array(
                    'item_id'   => $iid,
                    'field'     => 'audio_file',
                    'reconvert' => 1
                );
                jrCore_queue_create('jrAudio', 'audio_conversions', $_queue);
                $num++;
            }
            jrCore_form_modal_notice('update', "Submitted {$num} conversion queue entries");
        }
        else {
            // We are done
            break;
        }

    }
    jrCore_form_delete_session();
    jrCore_form_modal_notice('complete', "{$num} audio files were submitted for conversion");
    jrCore_exit();
}
