<?php
 /**
 * Jamroom Audio module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Jamroom file is LICENSED SOFTWARE, and cannot be redistributed.
 *
 * This Source Code is subject to the terms of the Jamroom Network
 * Commercial License -  please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: download_album
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAudio_download_album($_post, $_user, $_conf)
{
    if (!jrUser_is_admin() && jrCore_get_config_value('jrAudio', 'block_album_download', 'on') == 'on') {
        jrCore_notice_page('error', 'Audio album downloads are blocked for non-admin users');
    }
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid _profile_id - verify usage');
    }
    if (empty($_post['_2'])) {
        jrCore_notice_page('error', 'invalid album name - verify usage');
    }
    $profile_name = jrCore_db_get_item_key('jrProfile', $_post['_1'], 'profile_name');
    $zipfile_file = "album_" . jrCore_url_string($_post['_2']) . ".zip";
    $zipfile_name = "{$profile_name} - {$_post['_2']}.zip";

    // Do we exist?
    if (!jrCore_media_file_exists($_post['_1'], $zipfile_file)) {

        ignore_user_abort(true);
        if ($tim = jrCore_get_temp_value('jrAudio', $zipfile_name)) {
            // We are already being created - see how long it has been
            if ((time() - $tim) < 300) {
                // We are still under 5 minutes - exit
                // 'This album is currently being assembled for download - please try again in a few minutes'
                jrCore_notice_page('notice', 70, 'referrer');
            }
        }

        // Start our work
        jrCore_set_temp_value('jrAudio', $zipfile_name, time());

        // Get all audio files that are part of this album
        $_sp = array(
            'search'                       => array(
                "_profile_id = {$_post['_1']}",
                "audio_album_url = " . jrCore_url_string($_post['_2'])
            ),
            'return_keys'                  => array('_item_id', '_profile_id', 'profile_name', 'audio_title', 'audio_file_name', 'audio_file_track', 'audio_file_original_name', 'audio_file_size', 'audio_file_extension', 'audio_file_original_extension'),
            'exclude_jrUser_keys'          => true,
            'exclude_jrProfile_quota_keys' => true,
            'order_by'                     => array('audio_file_track' => 'numerical_asc'),
            'limit'                        => 100
        );
        $_rt = jrCore_db_search_items('jrAudio', $_sp);
        if ($_rt && is_array($_rt) && isset($_rt['_items'])) {

            $_fl = array();
            $_in = array();
            foreach ($_rt['_items'] as $_ai) {
                if (isset($_ai['audio_file_item_price']) && $_ai['audio_file_item_price'] > 0) {
                    // We are for sale... NOT included in this album download
                    continue;
                }
                $fld = false;
                $nam = false;
                // jrAudio_499_audio_file.wma.original.wma
                if (isset($_ai['audio_file_original_extension']) && strlen($_ai['audio_file_original_extension']) > 0) {
                    $nam = "jrAudio_{$_ai['_item_id']}_audio_file.{$_ai['audio_file_original_extension']}";
                    if (jrCore_media_file_exists($_post['_1'], "{$nam}.original.{$_ai['audio_file_original_extension']}")) {
                        $fld = $_ai['audio_file_original_name'];
                        $nam = "{$nam}.original.{$_ai['audio_file_original_extension']}";
                    }
                }
                if (!$fld) {
                    $fld = $_ai['audio_file_name'];
                    $nam = "jrAudio_{$_ai['_item_id']}_audio_file.{$_ai['audio_file_extension']}";
                }
                if ($fld && $nam) {
                    $_fl[$fld] = jrCore_get_media_directory($_post['_1'], FORCE_LOCAL) . '/' . $nam;
                    $_in[$fld] = $_ai;
                    jrCore_confirm_media_file_is_local($_post['_1'], $nam);
                }
            }
            if (count($_fl) > 0) {

                // Create ZIP file of all songs we collected
                $cdr = jrCore_get_module_cache_dir('jrAudio');
                $tmp = "{$cdr}/{$zipfile_file}";

                $track = 1;
                foreach ($_fl as $file_name => $file_path) {
                    $dsp = str_pad($track, 2, '0', STR_PAD_LEFT) . ' - ' . ucwords(trim(preg_replace('!\s+!', ' ', $_in[$file_name]['audio_title']))) . '.' . jrCore_file_extension($file_path);
                    copy($file_path, "{$cdr}/{$dsp}");
                    $_fl[$dsp] = "{$cdr}/{$dsp}";
                    unset($_fl[$file_name]);
                    $track++;
                }

                jrCore_create_zip_file($tmp, $_fl);
                if (!is_file($tmp)) {
                    jrCore_delete_temp_value('jrAudio', $zipfile_name);
                    jrCore_notice_page('error', 'unable to create album download ZIP file');
                }
                if (!jrCore_write_media_file($_post['_1'], $zipfile_file, $tmp)) {
                    jrCore_delete_temp_value('jrAudio', $zipfile_name);
                    jrCore_notice_page('error', 'unable to create album download ZIP file (2)');
                }

            }
            else {
                jrCore_delete_temp_value('jrAudio', $zipfile_name);
                jrCore_notice_page('error', 'unable to create album download ZIP file (3)');
            }
        }
        else {
            // no entries in this album!
            jrCore_delete_temp_value('jrAudio', $zipfile_name);
            jrCore_notice_page('error', 'There were no audio files found to download for this album');
        }
        jrCore_delete_temp_value('jrAudio', $zipfile_name);
    }
    jrCore_media_file_download($_post['_1'], $zipfile_file, $zipfile_name);
    jrCore_exit();
}
