<?php
/**
 * @copyright 2012 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Decode an OGG file
 * @param string $input_file Input Audio File
 * @param array $_options Conversion options array
 * @param string $error_file Conversion errors save file
 * @return string
 */
function jrAudio_ogg_decode($input_file, $_options, $error_file)
{
    return $input_file;
}

/**
 * Encode an OGG file
 * @param string $input_file Input Audio File
 * @param array $_options Conversion options array
 * @param string $error_file Conversion errors save file
 * @return string
 */
function jrAudio_ogg_encode($input_file, $_options, $error_file)
{
    // Get ffmpeg location
    $ffmpeg = jrCore_get_tool_path('ffmpeg', 'jrCore');

    // Extra decode options
    $d_options = '';
    if (isset($_options['decode_options']) && strlen($_options['decode_options']) > 0) {
        $d_options = trim($_options['decode_options']);
    }
    // Extra encode options
    $e_options = '';
    if (isset($_options['encode_options']) && strlen($_options['encode_options']) > 0) {
        $e_options = trim($_options['encode_options']);
    }

    ob_start();
    jrCore_run_module_function('jrCloudClient_start_timer', 'jrAudio', 'convert');
    system("nice -n 9 {$ffmpeg} -analyzeduration 30000000 -probesize 30000000 -y {$d_options} -i \"{$input_file}\" -map 0:a -threads 1 -strict -2 {$e_options} -acodec vorbis -ac 2 -aq 2 \"{$input_file}.ogg\" >/dev/null 2>{$error_file}");
    jrCore_run_module_function('jrCloudClient_stop_timer', 'jrAudio', 'convert');
    ob_end_clean();
    return "{$input_file}.ogg";
}