<?php
 /**
 * Jamroom Analytics module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: eventsource
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrAnalytics_eventsource($_post, $_user, $_conf)
{
    if (empty($_post['_1'])) {
        jrCore_notice('error', 'must provide at least one event', false);
    }
    $_ev = explode(',', basename($_post['_1']));
    foreach ($_ev as $event) {
        if (is_file(APP_DIR . "/modules/jrAnalytics/events/{$event}.php")) {
            require_once APP_DIR . "/modules/jrAnalytics/events/{$event}.php";
        }
    }
    ini_set('max_execution_time', 86400);
    header('Connection: keep-alive');
    header('Cache-Control: no-store');
    header('Content-Type: text/event-stream');
    $cnt = 0;
    while (true) {
        $upd = jrCore_format_time(time());
        $_rs = array('updated' => $upd);
        foreach ($_ev as $event) {
            $func = "jrAnalytics_event_{$event}_data";
            if (function_exists($func)) {
                jrCore_page_set_no_header_or_footer();
                $_rs[$event] = array(
                    'result'  => $func($_post, $_user, $_conf),
                    'updated' => $upd
                );
            }
        }
        $_rs['memory'] = jrCore_format_size(memory_get_peak_usage(true));
        $data = json_encode($_rs);
        $jerr = json_last_error_msg();
        if (strtolower($jerr) !== 'no error') {
            $data = json_encode(array('error' => $jerr));
        }
        ob_start();
        echo "event: {$_post['_1']}\n";
        echo "data: {$data}";
        echo "\n\n";
        ob_end_flush();
        @ob_flush();
        @flush();
        if (connection_aborted()) {
            break;
        }
        else {
            sleep(10);
            $cnt++;
            if ($cnt >= 360) {
                break;
            }
        }
    }
    // @note: we do NOT use jrCore_exit() here otherwise this long
    // running process will get recorded to the metric results
    exit;
}
