// Jamroom Analytics module Admin Javascript
// @copyright 2003-2022 by Talldude Networks LLC

var __gc = null;

/**
 * Initialize a new server sent event listener
 * @param {string} f Event(s) - separate multiple with a comma
 */
function jrAnalytics_init_sse_event_listener(f)
{
    const s = new EventSource(core_system_url + '/' + jrAnalytics_url + '/eventsource/' + f, {withCredentials: true});
    s.addEventListener(f, function(e) {
        jrAnalytics_parse_event_data(f, e);
    });
}

/**
 * Parse the event data coming back from the event
 * @param {string} f Event(s) - separate multiple with a comma
 * @param {object} e Event data
 */
function jrAnalytics_parse_event_data(f, e)
{
    if (typeof e.data !== 'undefined') {
        var d;
        try {
            d = JSON.parse(e.data);
        } catch (x) {
            console.error('Invalid JSON: ' + x);  // OK
            console.error(e.data);  // OK
        }
        if (typeof d !== 'undefined') {
            f.split(',').forEach(function(i) {
                var c = 'jrAnalytics_event_' + i;
                if (typeof window[c] === 'function') {
                    return window[c](d[i]);
                }
            });
            if (typeof d.updated !== 'undefined') {
                $('#al-updated').text(d.updated);
            }
            if (typeof d.memory !== 'undefined') {
                $('#al-max-memory').text(d.memory);
            }
        }
    }
    else {
        console.error('No JSON response received from eventsource');  // OK
    }
}

/**
 * Create a new analytics tag
 */
function jrAnalytics_create_tag()
{
    var u = core_system_url + '/' + jrAnalytics_url + '/create_tag';
    jrCore_set_csrf_cookie(u);
    $.post(u, function(r) {
        if (typeof r.error !== "undefined") {
            jrCore_alert(r.error);
        }
        else {
            $('#al-new-tag').empty().html(r.html).modal();
        }
    });
}

/**
 * Load user info
 * @param {number} u User ID
 * @param {string} i IP Address
 * @return void
 */
function jrAnalytics_load_user_info(u, i)
{
    var o = core_system_url + '/' + jrAnalytics_url + '/user_info';
    jrCore_set_csrf_cookie(o);
    $.get(o, {user_id: u, user_ip: i}, function(r) {
        if (typeof r.error !== "undefined") {
            jrCore_alert(r.error);
        }
        else {
            $('#al-user-info').empty().html(r.html).modal();
        }
    });

}

/**
 * Change count by incrementing
 * @param string i Count ID holder ID
 * @param number t Number to count to
 */
function jrAnalytics_change_count(i, t)
{
    if (typeof t === 'undefined') {
        t = '0';
    }
    var u = $(i);
    var s, d, v;
    var f = Number(u.text().replace(',', ''));
    t = Number(t);
    if (isNaN(t)) {
        return;
    }
    if (f === t) {
        // No change
        u.text(f.toLocaleString());
    }
    else {
        u.fadeOut(200, function() {
            u.text(t.toLocaleString()).fadeIn(250);
        })
    }
}

// Events

/**
 * Daily active/new users
 * @param {object} d result from event
 */
function jrAnalytics_event_user_daily_active(d)
{
    if (typeof d.result !== 'undefined') {
        jrAnalytics_change_count('#al-dau-users', d.result.dau);
        jrAnalytics_change_count('#al-new-users', d.result.new);
    }
}

/**
 * Show active URLs
 * @param {object} d result from event
 */
function jrAnalytics_event_user_online_info(d)
{
    jrAnalytics_change_count('#al-now-users', d.result.now);
    jrAnalytics_change_count('#al-max-users', d.result.max);
    jrAnalytics_change_count('#al-active-users', d.result.cnt);
    jrAnalytics_change_count('#al-bot-users', d.result.bot);
    jrAnalytics_change_count('#al-visitor-users', d.result.vis);
    $('#al-user-online-info').html(d.result.html);
    $('#al-user-tech').html(d.result.tech);
    $('#al-user-bots').html(d.result.bots);
    $('#al-user-visitors').html(d.result.visitors);
    if (__gc == null) {
        __gc = new google.visualization.GeoChart(document.getElementById('regions_div'));
    }
    var a = [
        ['Country', 'Count'],
    ];
    for (var i in d.result._cty) {
        a.push([i, d.result._cty[i]]);
    }
    var d = google.visualization.arrayToDataTable(a);
    __gc.draw(d, {});
}

/**
 * Daily active/new users
 * @param {object} d result from event
 */
function jrAnalytics_event_user_referral_info(d)
{
    if (typeof d.result !== 'undefined') {
        $('#al-user-referral').html(d.result.html);
        jrAnalytics_change_count('#al-total-referrals', d.result.refc);
    }
}