<?php
 /**
 * Jamroom Analytics module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2022 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * meta
 */
function jrAnalytics_meta()
{
    return array(
        'name'        => 'Analytics',
        'url'         => 'al',
        'version'     => '1.0.0',
        'developer'   => 'The Jamroom Network, &copy;' . date('Y'),
        'description' => 'Adds a realtime Analytics tab to your site Dashboard',
        'requires'    => 'jrCore:7.0.0b1',
        'license'     => 'mpl',
        'category'    => 'site',
        'recommended' => 'jrRedis'
    );
}

/**
 * init
 */
function jrAnalytics_init()
{
    jrCore_register_module_feature('jrCore', 'css', 'jrAnalytics', 'jrAnalytics.css');
    jrCore_register_module_feature('jrCore', 'javascript', 'jrAnalytics', 'jrAnalytics_admin.js', 'admin');

    jrCore_register_event_listener('jrCore', 'dashboard_tabs', 'jrAnalytics_dashboard_tabs_listener');
    jrCore_register_event_listener('jrCore', 'process_init', 'jrAnalytics_process_init_listener');
    jrCore_register_event_listener('jrCore', 'process_done', 'jrAnalytics_process_done_listener');
    jrCore_register_event_listener('jrCore', 'minute_maintenance', 'jrAnalytics_minute_maintenance_listener');

    jrCore_register_event_trigger('jrAnalytics', 'session_agent_info', 'Fired with parsed User Agent and session data');
    jrCore_register_event_trigger('jrAnalytics', 'view_user_info', 'Fired with user data when viewing individual online user');
    jrCore_register_event_trigger('jrAnalytics', 'referring_domain', 'Fired with the referring domain when saving a referrer');

    // Graph Support
    $_tmp = array(
        'title'    => 'Daily Referrers',
        'function' => 'jrAnalytics_graph_daily_referrers',
        'group'    => 'admin'
    );
    jrCore_register_module_feature('jrGraph', 'graph_config', 'jrAnalytics', 'daily_referrers', $_tmp);

    // Queue workers
    jrCore_register_queue_worker('jrAnalytics', 'process_page_views', 'jrAnalytics_process_page_views_worker', 0, 1, 55);
    return true;
}

// Bring in Library
require_once APP_DIR . '/modules/jrAnalytics/lib/dashboard.php';
require_once APP_DIR . '/modules/jrAnalytics/lib/functions.php';
require_once APP_DIR . '/modules/jrAnalytics/lib/listeners.php';
require_once APP_DIR . '/modules/jrAnalytics/lib/workers.php';
