<?php
/**
 * Jamroom Analytics SSE Event function
 * @copyright 2003 - 2022 by The Jamroom Network
 * @author Brian Johnson - brian@jamroom.net
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * Users Online Count (current + max)
 * @return string
 */
function jrAnalytics_event_user_referral_info_data($_post, $_user, $_conf)
{
    $key = 'dashboard_user_referral_info';
    if (!$_ct = jrCore_get_local_cache_key($key)) {

        $dat             = array();
        $dat[1]['title'] = '&nbsp;';
        $dat[1]['width'] = '3%';
        $dat[2]['title'] = 'Source';
        $dat[2]['width'] = '87%';
        $dat[3]['title'] = 'Count';
        $dat[3]['width'] = '10%';
        jrCore_page_table_header($dat);

        $ttl = 0;
        $now = jrCore_format_time(time(), true, '%Y%m%d');
        $tbl = jrCore_db_table_name('jrCore', 'stat_count');
        $req = "SELECT stat_index AS s, stat_value AS v FROM {$tbl} WHERE stat_module = 'jrAnalytics' AND stat_key = 'ref' AND stat_date = {$now} ORDER BY v DESC";
        $_rt = jrCore_db_query($req, 'NUMERIC');
        if (is_array($_rt)) {
            $idx = 1;
            $url = jrCore_get_module_url('jrAnalytics');
            foreach ($_rt as $r) {
                if (jrAnalytics_is_blocked_domain($r['s'])) {
                    continue;
                }
                if ($idx <= 15) {
                    $dat             = array();
                    $dat[1]['title'] = $idx;
                    $dat[1]['class'] = 'center';
                    $dat[2]['title'] = "<a href=\"https://{$r['s']}\" target=\"_blank\">{$r['s']}</a>";
                    $dat[2]['class'] = 'word-break';
                    $dat[3]['title'] = "<a onclick=\"jrGraph_modal_graph('#al-graph-modal', '{$url}', 'daily_referrers', {domain: '{$r['s']}'} );return false\"><u>" . jrCore_number_format($r['v']) . '</u></a>';
                    $dat[3]['class'] = 'center';
                    jrCore_page_table_row($dat, null, $r);
                }
                $ttl += $r['v'];
                $idx++;
            }
        }
        jrCore_page_table_footer();
        $_ct = array(
            'refc' => $ttl,
            'html' => jrCore_page_display(true)
        );
        jrCore_set_local_cache_key($key, $_ct, 30);
    }
    return $_ct;
}